/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.ComponentOrientation;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class VWWebAppComboBox
extends JComboBox {
    private static final String[] APP_NAMES = new String[]{VWResource.s_fileNetWorkplace, VWResource.s_ibmWorkplaceXT, VWResource.s_fileNetWebServices, VWResource.s_fileNetOpenClient, VWResource.s_fileNetCollaboration, VWResource.s_fileNetWCM, VWResource.s_fileNetRecordsManager, VWResource.s_ibmECMWidgetsLotusMashups, VWResource.s_ibmECMWidgetsBusinessSpace, VWResource.s_ibmContentNavigator};
    public static final int LAST_IBM_WEB_APP_INDEX = 10;
    public static final int MAX_WEB_APP_ID = 999;

    public VWWebAppComboBox() {
        this.setRenderer(new VWLabelListCellRenderer());
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
        this.setEditable(false);
    }

    public VWWebAppComboBox(boolean bIncludeSystemDefined) {
        this.setRenderer(new VWLabelListCellRenderer());
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
        DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>(APP_NAMES);
        if (cbModel != null) {
            if (bIncludeSystemDefined) {
                cbModel.insertElementAt(VWResource.s_systemDefined, 0);
            }
            this.setModel(cbModel);
        }
        this.setEditable(true);
    }

    public void initialize(Hashtable webAppTable) {
        DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
        if (cbModel != null) {
            if (webAppTable != null) {
                for (int nIndex = 0; nIndex < APP_NAMES.length; ++nIndex) {
                    Integer webAppId = VWWebAppComboBox.lookupWebAppId(APP_NAMES[nIndex]);
                    if (webAppId == null || !webAppTable.containsKey(webAppId)) continue;
                    cbModel.addElement(APP_NAMES[nIndex]);
                }
            }
            this.setModel(cbModel);
        }
    }

    public Integer getSelectedWebApp() {
        block6: {
            try {
                String value = (String)this.getSelectedItem();
                if (value == null) break block6;
                Integer webAppId = VWWebAppComboBox.lookupWebAppId(value);
                if (webAppId != null) {
                    return webAppId;
                }
                try {
                    int nWebAppId = Integer.parseInt(value);
                    if (nWebAppId != -1 && nWebAppId >= 100 && nWebAppId <= 999) {
                        return new Integer(nWebAppId);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSelectedWebApp(Object value) {
        ActionListener[] listeners = this.getActionListeners();
        try {
            block29: {
                if (listeners != null) {
                    for (int i = 0; i < listeners.length; ++i) {
                        this.removeActionListener(listeners[i]);
                    }
                }
                int nWebAppId = -1;
                if (value != null) {
                    if (value instanceof String) {
                        String strValue = ((String)value).trim();
                        if (strValue.length() > 0) {
                            try {
                                nWebAppId = Integer.parseInt(strValue);
                            }
                            catch (NumberFormatException ex) {}
                        }
                    } else if (value instanceof Integer) {
                        nWebAppId = (Integer)value;
                    }
                }
                if (nWebAppId == -1) break block29;
                if (nWebAppId >= 100) {
                    this.setSelectedItem(Integer.toString(nWebAppId));
                    break block29;
                }
                switch (nWebAppId) {
                    case 1: {
                        this.setSelectedItem(VWResource.s_fileNetWorkplace);
                        break;
                    }
                    case 7: {
                        this.setSelectedItem(VWResource.s_ibmWorkplaceXT);
                        break;
                    }
                    case 2: {
                        this.setSelectedItem(VWResource.s_fileNetWebServices);
                        break;
                    }
                    case 3: {
                        this.setSelectedItem(VWResource.s_fileNetOpenClient);
                        break;
                    }
                    case 4: {
                        this.setSelectedItem(VWResource.s_fileNetCollaboration);
                        break;
                    }
                    case 5: {
                        this.setSelectedItem(VWResource.s_fileNetWCM);
                        break;
                    }
                    case 6: {
                        this.setSelectedItem(VWResource.s_fileNetRecordsManager);
                        break;
                    }
                    case 8: {
                        this.setSelectedItem(VWResource.s_ibmECMWidgetsLotusMashups);
                        break;
                    }
                    case 9: {
                        this.setSelectedItem(VWResource.s_ibmECMWidgetsBusinessSpace);
                        break;
                    }
                    case 10: {
                        this.setSelectedItem(VWResource.s_ibmContentNavigator);
                    }
                }
            }
            Object var7_7 = null;
            if (listeners == null) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (listeners == null) throw throwable;
            for (int i = 0; i < listeners.length; ++i) {
                this.addActionListener(listeners[i]);
            }
            throw throwable;
        }
        for (int i = 0; i < listeners.length; ++i) {
            this.addActionListener(listeners[i]);
        }
        {
            return;
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var7_8 = null;
                if (listeners == null) return;
                for (int i = 0; i < listeners.length; ++i) {
                    this.addActionListener(listeners[i]);
                }
                return;
            }
        }
    }

    public static Integer lookupWebAppId(String webAppName) {
        if (webAppName.length() == 0 || VWStringUtils.compare(webAppName, VWResource.s_systemDefined) == 0) {
            return new Integer(0);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_fileNetWorkplace) == 0) {
            return new Integer(1);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_ibmWorkplaceXT) == 0) {
            return new Integer(7);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_fileNetWebServices) == 0) {
            return new Integer(2);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_fileNetOpenClient) == 0) {
            return new Integer(3);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_fileNetCollaboration) == 0) {
            return new Integer(4);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_fileNetWCM) == 0) {
            return new Integer(5);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_fileNetRecordsManager) == 0) {
            return new Integer(6);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_ibmECMWidgetsLotusMashups) == 0) {
            return new Integer(8);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_ibmECMWidgetsBusinessSpace) == 0) {
            return new Integer(9);
        }
        if (VWStringUtils.compare(webAppName, VWResource.s_ibmContentNavigator) == 0) {
            return new Integer(10);
        }
        return null;
    }

    public static String getWebAppNameFromId(int nId) {
        switch (nId) {
            case 1: {
                return VWResource.s_fileNetWorkplace;
            }
            case 7: {
                return VWResource.s_ibmWorkplaceXT;
            }
            case 2: {
                return VWResource.s_fileNetWebServices;
            }
            case 3: {
                return VWResource.s_fileNetOpenClient;
            }
            case 4: {
                return VWResource.s_fileNetCollaboration;
            }
            case 5: {
                return VWResource.s_fileNetWCM;
            }
            case 6: {
                return VWResource.s_fileNetRecordsManager;
            }
            case 8: {
                return VWResource.s_ibmECMWidgetsLotusMashups;
            }
            case 9: {
                return VWResource.s_ibmECMWidgetsBusinessSpace;
            }
            case 10: {
                return VWResource.s_ibmContentNavigator;
            }
        }
        return Integer.toString(nId);
    }

    public static boolean isP8WebApp(int nWebAppId) {
        switch (nWebAppId) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }
}

